@extends('admin.layout.page-app')
@section('page_title', __('label.badge_settings'))
@section('tab_title', __('label.badge_settings'))

@section('content')
    @include('admin.layout.sidebar')

    <div class="right-content">
        @include('admin.layout.header')

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm">{{__('label.badge_settings')}}</h1>

            <div class="border-bottom row">
                <div class="col-sm-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{__('label.dashboard')}}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('label.badge_settings')}}</li>
                    </ol>
                </div>
            </div>

            <form id="badge_setting" enctype="multipart/form-data">
                <div class="card custom-border-card mt-3">
                    <h5 class="card-header">{{__('label.badge_settings_status')}}</h5>
                    <div class="card-body">
                        <div class="form-row">
                            <div class="col-md-12">
                                <div class="form-group mb-0">
                                    <div class="radio-group mb-0">
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="badge_status_yes" name="badge_status" class="custom-control-input" {{ $setting_data['badge_status'] == 1 ? "checked" : "" }} value="1">
                                            <label class="custom-control-label" for="badge_status_yes">{{__('label.yes')}}</label>
                                        </div>
                                        <div class="custom-control custom-radio">
                                            <input type="radio" id="badge_status_no" name="badge_status" class="custom-control-input" {{ $setting_data['badge_status'] == 0 ? "checked" : "" }} value="0">
                                            <label class="custom-control-label" for="badge_status_no">{{__('label.no')}}</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <!-- Practice Badge -->
                    <div class="col-md-6">
                        <div class="card custom-border-card">
                            <div class="d-flex align-items-center justify-content-between border-bottom">
                                <h5 class="badge-header">{{ __('label.practice_quiz_badge') }}</h5>
                                <button type="button" onclick="change_status(1)" id="1" class="{{ $badge_data[0]['status'] == 1 ? 'show-btn' : 'hide-btn' }} mb-2">
                                    {{ $badge_data[0]['status'] == 1 ? __('label.show') : __('label.hide') }}
                                </button>
                            </div>

                            <div class="card-body">
                                <div class="form-row">
                                    <div class="col-md-8">
                                        <div class="form-row">
                                            <div class="form-group col-md-12">
                                                <label>{{__('label.label')}}<span class="text-danger">*</span></label>
                                                <input type="text" name="1_label" value="{{ $badge_data[0]['label']}}" class="form-control" placeholder="{{__('label.label_here')}}">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>{{__('label.min_quiz_pass')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="1_min_pass_quiz" value="{{ $badge_data[0]['min_pass_quiz']}}" class="form-control" placeholder="{{__('label.min_quiz_here')}}">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>{{__('label.earning_coin')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="1_earning_coin" value="{{ $badge_data[0]['earning_coin'] }}" class="form-control" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group ml-4">
                                            <label>{{__('label.image')}}<span class="text-danger">*</span></label>
                                            <div class="avatar-upload">
                                                <div class="avatar-edit">
                                                    <input type='file' name="1_image" id="imageSelect_1" accept=".png, .jpg, .jpeg" />
                                                    <label for="imageSelect_1" title="{{__('label.upload_file')}}"></label>
                                                </div>
                                                <div class="avatar-preview">
                                                    <img src="{{$badge_data[0]['image']}}" id="imageView_1">
                                                </div>
                                            </div>
                                            <input type="hidden" name="1_old_image" value="{{$badge_data[0]['image']}}">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-12">
                                        <label>{{__('label.description')}}</label>
                                        <textarea name="1_description" rows="1" class="form-control" placeholder="{{__('label.description_here')}}">{{$badge_data[0]['description']}}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Normal Badge -->
                    <div class="col-md-6">
                        <div class="card custom-border-card">
                            <div class="d-flex align-items-center justify-content-between border-bottom">
                                <h5 class="badge-header">{{ __('label.normal_quiz_badge') }}</h5>
                                <button type="button" onclick="change_status(2)" id="2" class="{{ $badge_data[1]['status'] == 1 ? 'show-btn' : 'hide-btn' }} mb-2">
                                    {{ $badge_data[1]['status'] == 1 ? __('label.show') : __('label.hide') }}
                                </button>
                            </div>

                            <div class="card-body">
                                <div class="form-row">
                                    <div class="col-md-8">
                                        <div class="form-row">
                                            <div class="form-group col-md-12">
                                                <label>{{__('label.label')}}<span class="text-danger">*</span></label>
                                                <input type="text" name="2_label" value="{{$badge_data[1]['label']}}" class="form-control" placeholder="{{__('label.label_here')}}">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>{{__('label.min_quiz_pass')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="2_min_pass_quiz" value="{{$badge_data[1]['min_pass_quiz']}}" class="form-control" placeholder="{{__('label.min_quiz_here')}}">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>{{__('label.earning_coin')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="2_earning_coin" value="{{ $badge_data[1]['earning_coin'] }}" class="form-control" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group ml-4">
                                            <label>{{__('label.image')}}<span class="text-danger">*</span></label>
                                            <div class="avatar-upload">
                                                <div class="avatar-edit">
                                                    <input type='file' name="2_image" id="imageSelect_2" accept=".png, .jpg, .jpeg" />
                                                    <label for="imageSelect_2" title="{{__('label.upload_file')}}"></label>
                                                </div>
                                                <div class="avatar-preview">
                                                    <img src="{{$badge_data[1]['image']}}" id="imageView_2">
                                                </div>
                                            </div>
                                            <input type="hidden" name="2_old_image" value="{{$badge_data[1]['image']}}">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-12">
                                        <label>{{__('label.description')}}</label>
                                        <textarea name="2_description" rows="1" class="form-control" placeholder="{{__('label.description_here')}}">{{$badge_data[1]['description']}}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <!-- Audio Badge -->
                    <div class="col-md-6">
                        <div class="card custom-border-card">
                            <div class="d-flex align-items-center justify-content-between border-bottom">
                                <h5 class="badge-header">{{ __('label.audio_quiz_badge') }}</h5>
                                <button type="button" onclick="change_status(3)" id="3" class="{{ $badge_data[2]['status'] == 1 ? 'show-btn' : 'hide-btn' }} mb-2">
                                    {{ $badge_data[2]['status'] == 1 ? __('label.show') : __('label.hide') }}
                                </button>
                            </div>

                            <div class="card-body">
                                <div class="form-row">
                                    <div class="col-md-8">
                                        <div class="form-row">
                                            <div class="form-group col-md-12">
                                                <label>{{__('label.label')}}<span class="text-danger">*</span></label>
                                                <input type="text" name="3_label" value="{{$badge_data[2]['label']}}" class="form-control" placeholder="{{__('label.label_here')}}">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>{{__('label.min_quiz_pass')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="3_min_pass_quiz" value="{{$badge_data[2]['min_pass_quiz']}}" class="form-control" placeholder="{{__('label.min_quiz_here')}}">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>{{__('label.earning_coin')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="3_earning_coin" value="{{ $badge_data[2]['earning_coin'] }}" class="form-control" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group ml-4">
                                            <label>{{__('label.image')}}<span class="text-danger">*</span></label>
                                            <div class="avatar-upload">
                                                <div class="avatar-edit">
                                                    <input type='file' name="3_image" id="imageSelect_3" accept=".png, .jpg, .jpeg" />
                                                    <label for="imageSelect_3" title="{{__('label.upload_file')}}"></label>
                                                </div>
                                                <div class="avatar-preview">
                                                    <img src="{{$badge_data[2]['image']}}" id="imageView_3">
                                                </div>
                                            </div>
                                            <input type="hidden" name="3_old_image" value="{{$badge_data[2]['image']}}">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-12">
                                        <label>{{__('label.description')}}</label>
                                        <textarea name="3_description" rows="1" class="form-control" placeholder="{{__('label.description_here')}}">{{$badge_data[2]['description']}}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Video Badge -->
                    <div class="col-md-6">
                        <div class="card custom-border-card">
                            <div class="d-flex align-items-center justify-content-between border-bottom">
                                <h5 class="badge-header">{{ __('label.video_quiz_badge') }}</h5>
                                <button type="button" onclick="change_status(4)" id="4" class="{{ $badge_data[3]['status'] == 1 ? 'show-btn' : 'hide-btn' }} mb-2">
                                    {{ $badge_data[3]['status'] == 1 ? __('label.show') : __('label.hide') }}
                                </button>
                            </div>

                            <div class="card-body">
                                <div class="form-row">
                                    <div class="col-md-8">
                                        <div class="form-row">
                                            <div class="form-group col-md-12">
                                                <label>{{__('label.label')}}<span class="text-danger">*</span></label>
                                                <input type="text" name="4_label" value="{{$badge_data[3]['label']}}" class="form-control" placeholder="{{__('label.label_here')}}">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>{{__('label.min_quiz_pass')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="4_min_pass_quiz" value="{{$badge_data[3]['min_pass_quiz']}}" class="form-control" placeholder="{{__('label.min_quiz_here')}}">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>{{__('label.earning_coin')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="4_earning_coin" value="{{ $badge_data[3]['earning_coin'] }}" class="form-control" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group ml-4">
                                            <label>{{__('label.image')}}<span class="text-danger">*</span></label>
                                            <div class="avatar-upload">
                                                <div class="avatar-edit">
                                                    <input type='file' name="4_image" id="imageSelect_4" accept=".png, .jpg, .jpeg" />
                                                    <label for="imageSelect_4" title="{{__('label.upload_file')}}"></label>
                                                </div>
                                                <div class="avatar-preview">
                                                    <img src="{{$badge_data[3]['image']}}" id="imageView_4">
                                                </div>
                                            </div>
                                            <input type="hidden" name="4_old_image" value="{{$badge_data[3]['image']}}">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-12">
                                        <label>{{__('label.description')}}</label>
                                        <textarea name="4_description" rows="1" class="form-control" placeholder="{{__('label.description_here')}}">{{$badge_data[3]['description']}}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <!-- True-False Badge -->
                    <div class="col-md-6">
                        <div class="card custom-border-card">
                            <div class="d-flex align-items-center justify-content-between border-bottom">
                                <h5 class="badge-header">{{ __('label.true_false_quiz_badge') }}</h5>
                                <button type="button" onclick="change_status(5)" id="5" class="{{ $badge_data[4]['status'] == 1 ? 'show-btn' : 'hide-btn' }} mb-2">
                                    {{ $badge_data[4]['status'] == 1 ? __('label.show') : __('label.hide') }}
                                </button>
                            </div>

                            <div class="card-body">
                                <div class="form-row">
                                    <div class="col-md-8">
                                        <div class="form-row">
                                            <div class="form-group col-md-12">
                                                <label>{{__('label.label')}}<span class="text-danger">*</span></label>
                                                <input type="text" name="5_label" value="{{$badge_data[4]['label']}}" class="form-control" placeholder="{{__('label.label_here')}}">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>{{__('label.min_quiz_pass')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="5_min_pass_quiz" value="{{$badge_data[4]['min_pass_quiz']}}" class="form-control" placeholder="{{__('label.min_quiz_here')}}">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>{{__('label.earning_coin')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="5_earning_coin" value="{{ $badge_data[4]['earning_coin'] }}" class="form-control" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group ml-4">
                                            <label>{{__('label.image')}}<span class="text-danger">*</span></label>
                                            <div class="avatar-upload">
                                                <div class="avatar-edit">
                                                    <input type='file' name="5_image" id="imageSelect_5" accept=".png, .jpg, .jpeg" />
                                                    <label for="imageSelect_5" title="{{__('label.upload_file')}}"></label>
                                                </div>
                                                <div class="avatar-preview">
                                                    <img src="{{$badge_data[4]['image']}}" id="imageView_5">
                                                </div>
                                            </div>
                                            <input type="hidden" name="5_old_image" value="{{$badge_data[4]['image']}}">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-12">
                                        <label>{{__('label.description')}}</label>
                                        <textarea name="5_description" rows="1" class="form-control" placeholder="{{__('label.description_here')}}">{{$badge_data[4]['description']}}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Fear Factor Badge -->
                    <div class="col-md-6">
                        <div class="card custom-border-card">
                            <div class="d-flex align-items-center justify-content-between border-bottom">
                                <h5 class="badge-header">{{ __('label.fear_factor_quiz_badge') }}</h5>
                                <button type="button" onclick="change_status(6)" id="6" class="{{ $badge_data[5]['status'] == 1 ? 'show-btn' : 'hide-btn' }} mb-2">
                                    {{ $badge_data[5]['status'] == 1 ? __('label.show') : __('label.hide') }}
                                </button>
                            </div>

                            <div class="card-body">
                                <div class="form-row">
                                    <div class="col-md-8">
                                        <div class="form-row">
                                            <div class="form-group col-md-12">
                                                <label>{{__('label.label')}}<span class="text-danger">*</span></label>
                                                <input type="text" name="6_label" value="{{$badge_data[5]['label']}}" class="form-control" placeholder="{{__('label.label_here')}}">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>{{__('label.min_quiz_pass')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="6_min_pass_quiz" value="{{$badge_data[5]['min_pass_quiz']}}" class="form-control" placeholder="{{__('label.min_quiz_here')}}">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>{{__('label.earning_coin')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="6_earning_coin" value="{{ $badge_data[5]['earning_coin'] }}" class="form-control" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group ml-4">
                                            <label>{{__('label.image')}}<span class="text-danger">*</span></label>
                                            <div class="avatar-upload">
                                                <div class="avatar-edit">
                                                    <input type='file' name="6_image" id="imageSelect_6" accept=".png, .jpg, .jpeg" />
                                                    <label for="imageSelect_6" title="{{__('label.upload_file')}}"></label>
                                                </div>
                                                <div class="avatar-preview">
                                                    <img src="{{$badge_data[5]['image']}}" id="imageView_6">
                                                </div>
                                            </div>
                                            <input type="hidden" name="6_old_image" value="{{$badge_data[5]['image']}}">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-12">
                                        <label>{{__('label.description')}}</label>
                                        <textarea name="6_description" rows="1" class="form-control" placeholder="{{__('label.description_here')}}">{{$badge_data[5]['description']}}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <!-- One vs One Battles Badge -->
                    <div class="col-md-6">
                        <div class="card custom-border-card">
                            <div class="d-flex align-items-center justify-content-between border-bottom">
                                <h5 class="badge-header">{{ __('label.one_vs_one_battles_badge') }}</h5>
                                <button type="button" onclick="change_status(7)" id="7" class="{{ $badge_data[6]['status'] == 1 ? 'show-btn' : 'hide-btn' }} mb-2">
                                    {{ $badge_data[6]['status'] == 1 ? __('label.show') : __('label.hide') }}
                                </button>
                            </div>

                            <div class="card-body">
                                <div class="form-row">
                                    <div class="col-md-8">
                                        <div class="form-row">
                                            <div class="form-group col-md-12">
                                                <label>{{__('label.label')}}<span class="text-danger">*</span></label>
                                                <input type="text" name="7_label" value="{{$badge_data[6]['label']}}" class="form-control" placeholder="{{__('label.label_here')}}">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>{{__('label.min_battles_win')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="7_min_pass_quiz" value="{{$badge_data[6]['min_pass_quiz']}}" class="form-control" placeholder="{{__('label.min_battles_here')}}">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>{{__('label.earning_coin')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="7_earning_coin" value="{{ $badge_data[6]['earning_coin'] }}" class="form-control" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group ml-4">
                                            <label>{{__('label.image')}}<span class="text-danger">*</span></label>
                                            <div class="avatar-upload">
                                                <div class="avatar-edit">
                                                    <input type='file' name="7_image" id="imageSelect_7" accept=".png, .jpg, .jpeg" />
                                                    <label for="imageSelect_7" title="{{__('label.upload_file')}}"></label>
                                                </div>
                                                <div class="avatar-preview">
                                                    <img src="{{$badge_data[6]['image']}}" id="imageView_7">
                                                </div>
                                            </div>
                                            <input type="hidden" name="7_old_image" value="{{$badge_data[6]['image']}}">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-12">
                                        <label>{{__('label.description')}}</label>
                                        <textarea name="7_description" rows="1" class="form-control" placeholder="{{__('label.description_here')}}">{{$badge_data[6]['description']}}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Ultimate Challenge Badge -->
                    <div class="col-md-6">
                        <div class="card custom-border-card">
                            <div class="d-flex align-items-center justify-content-between border-bottom">
                                <h5 class="badge-header">{{ __('label.ultimate_challenge_badge') }}</h5>
                                <button type="button" onclick="change_status(8)" id="8" class="{{ $badge_data[7]['status'] == 1 ? 'show-btn' : 'hide-btn' }} mb-2">
                                    {{ $badge_data[7]['status'] == 1 ? __('label.show') : __('label.hide') }}
                                </button>
                            </div>

                            <div class="card-body">
                                <div class="form-row">
                                    <div class="col-md-8">
                                        <div class="form-row">
                                            <div class="form-group col-md-12">
                                                <label>{{__('label.label')}}<span class="text-danger">*</span></label>
                                                <input type="text" name="8_label" value="{{$badge_data[7]['label']}}" class="form-control" placeholder="{{__('label.label_here')}}">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>{{__('label.min_challenge_pass')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="8_min_pass_quiz" value="{{$badge_data[7]['min_pass_quiz']}}" class="form-control" placeholder="{{__('label.min_challenge_here')}}">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>{{__('label.earning_coin')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="8_earning_coin" value="{{ $badge_data[7]['earning_coin'] }}" class="form-control" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group ml-4">
                                            <label>{{__('label.image')}}<span class="text-danger">*</span></label>
                                            <div class="avatar-upload">
                                                <div class="avatar-edit">
                                                    <input type='file' name="8_image" id="imageSelect_8" accept=".png, .jpg, .jpeg" />
                                                    <label for="imageSelect_8" title="{{__('label.upload_file')}}"></label>
                                                </div>
                                                <div class="avatar-preview">
                                                    <img src="{{$badge_data[7]['image']}}" id="imageView_8">
                                                </div>
                                            </div>
                                            <input type="hidden" name="8_old_image" value="{{$badge_data[7]['image']}}">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-12">
                                        <label>{{__('label.description')}}</label>
                                        <textarea name="8_description" rows="1" class="form-control" placeholder="{{__('label.description_here')}}">{{$badge_data[7]['description']}}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <!-- Contest Badge -->
                    <div class="col-md-6">
                        <div class="card custom-border-card">
                            <div class="d-flex align-items-center justify-content-between border-bottom">
                                <h5 class="badge-header">{{ __('label.contest_badge') }}</h5>
                                <button type="button" onclick="change_status(9)" id="9" class="{{ $badge_data[8]['status'] == 1 ? 'show-btn' : 'hide-btn' }} mb-2">
                                    {{ $badge_data[8]['status'] == 1 ? __('label.show') : __('label.hide') }}
                                </button>
                            </div>

                            <div class="card-body">
                                <div class="form-row">
                                    <div class="col-md-8">
                                        <div class="form-row">
                                            <div class="form-group col-md-12">
                                                <label>{{__('label.label')}}<span class="text-danger">*</span></label>
                                                <input type="text" name="9_label" value="{{$badge_data[8]['label']}}" class="form-control" placeholder="{{__('label.label_here')}}">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>{{__('label.min_win_contest')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="9_min_win_contest" value="{{$badge_data[8]['min_win_contest']}}" class="form-control" placeholder="{{__('label.min_contest_here')}}">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>{{__('label.earning_coin')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="9_earning_coin" value="{{ $badge_data[8]['earning_coin'] }}" class="form-control" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group ml-4">
                                            <label>{{__('label.image')}}<span class="text-danger">*</span></label>
                                            <div class="avatar-upload">
                                                <div class="avatar-edit">
                                                    <input type='file' name="9_image" id="imageSelect_9" accept=".png, .jpg, .jpeg" />
                                                    <label for="imageSelect_9" title="{{__('label.upload_file')}}"></label>
                                                </div>
                                                <div class="avatar-preview">
                                                    <img src="{{$badge_data[8]['image']}}" id="imageView_9">
                                                </div>
                                            </div>
                                            <input type="hidden" name="9_old_image" value="{{$badge_data[8]['image']}}">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-12">
                                        <label>{{__('label.description')}}</label>
                                        <textarea name="9_description" rows="1" class="form-control" placeholder="{{__('label.description_here')}}">{{$badge_data[8]['description']}}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Daily Quiz Badge -->
                    <div class="col-md-6">
                        <div class="card custom-border-card">
                            <div class="d-flex align-items-center justify-content-between border-bottom">
                                <h5 class="badge-header">{{ __('label.daily_quiz_badge') }}</h5>
                                <button type="button" onclick="change_status(10)" id="10" class="{{ $badge_data[9]['status'] == 1 ? 'show-btn' : 'hide-btn' }} mb-2">
                                    {{ $badge_data[9]['status'] == 1 ? __('label.show') : __('label.hide') }}
                                </button>
                            </div>

                            <div class="card-body">
                                <div class="form-row">
                                    <div class="col-md-8">
                                        <div class="form-row">
                                            <div class="form-group col-md-12">
                                                <label>{{__('label.label')}}<span class="text-danger">*</span></label>
                                                <input type="text" name="10_label" value="{{ $badge_data[9]['label'] }}" class="form-control" placeholder="{{__('label.label_here')}}">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>{{__('label.min_day_play')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="10_min_day_play" value="{{ $badge_data[9]['min_day_play']}}" class="form-control" placeholder="{{__('label.min_day_here')}}">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>{{__('label.earning_coin')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="10_earning_coin" value="{{ $badge_data[9]['earning_coin'] }}" class="form-control" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group ml-4">
                                            <label>{{__('label.image')}}<span class="text-danger">*</span></label>
                                            <div class="avatar-upload">
                                                <div class="avatar-edit">
                                                    <input type='file' name="10_image" id="imageSelect_10" accept=".png, .jpg, .jpeg" />
                                                    <label for="imageSelect_10" title="{{__('label.upload_file')}}"></label>
                                                </div>
                                                <div class="avatar-preview">
                                                    <img src="{{$badge_data[9]['image']}}" id="imageView_10">
                                                </div>
                                            </div>
                                            <input type="hidden" name="10_old_image" value="{{$badge_data[9]['image']}}">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-12">
                                        <label>{{__('label.description')}}</label>
                                        <textarea name="10_description" rows="1" class="form-control" placeholder="{{__('label.description_here')}}">{{$badge_data[9]['description']}}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <!-- Coin Sharing Badge -->
                    <div class="col-md-6">
                        <div class="card custom-border-card">
                            <div class="d-flex align-items-center justify-content-between border-bottom">
                                <h5 class="badge-header">{{ __('label.coin_sharing_badge') }}</h5>
                                <button type="button" onclick="change_status(11)" id="11" class="{{ $badge_data[10]['status'] == 1 ? 'show-btn' : 'hide-btn' }} mb-2">
                                    {{ $badge_data[10]['status'] == 1 ? __('label.show') : __('label.hide') }}
                                </button>
                            </div>

                            <div class="card-body">
                                <div class="form-row">
                                    <div class="col-md-8">
                                        <div class="form-row">
                                            <div class="form-group col-md-12">
                                                <label>{{__('label.label')}}<span class="text-danger">*</span></label>
                                                <input type="text" name="11_label" value="{{ $badge_data[10]['label'] }}" class="form-control" placeholder="{{__('label.label_here')}}">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>{{__('label.min_coin_sharing')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="11_min_coin_sharing" value="{{ $badge_data[10]['min_coin_sharing'] }}" class="form-control" placeholder="{{__('label.min_coin_here')}}">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>{{__('label.earning_coin')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="11_earning_coin" value="{{ $badge_data[10]['earning_coin'] }}" class="form-control" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group ml-4">
                                            <label>{{__('label.image')}}<span class="text-danger">*</span></label>
                                            <div class="avatar-upload">
                                                <div class="avatar-edit">
                                                    <input type='file' name="11_image" id="imageSelect_11" accept=".png, .jpg, .jpeg" />
                                                    <label for="imageSelect_11" title="{{__('label.upload_file')}}"></label>
                                                </div>
                                                <div class="avatar-preview">
                                                    <img src="{{$badge_data[10]['image']}}" id="imageView_11">
                                                </div>
                                            </div>
                                            <input type="hidden" name="11_old_image" value="{{$badge_data[10]['image']}}">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-12">
                                        <label>{{__('label.description')}}</label>
                                        <textarea name="11_description" rows="1" class="form-control" placeholder="{{__('label.description_here')}}">{{$badge_data[10]['description']}}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Subscription Badge -->
                    <div class="col-md-6">
                        <div class="card custom-border-card">
                            <div class="d-flex align-items-center justify-content-between border-bottom">
                                <h5 class="badge-header">{{__('label.subscription_badge')}}</h5>
                                <button type="button" onclick="change_status(12)" id="12" class="{{ $badge_data[11]['status'] == 1 ? 'show-btn' : 'hide-btn' }} mb-2">
                                    {{ $badge_data[11]['status'] == 1 ? __('label.show') : __('label.hide') }}
                                </button>
                            </div>

                            <div class="card-body">
                                <div class="form-row">
                                    <div class="col-md-8">
                                        <div class="form-row">
                                            <div class="form-group col-md-12">
                                                <label>{{__('label.label')}}<span class="text-danger">*</span></label>
                                                <input type="text" name="12_label" value="{{$badge_data[11]['label']}}" class="form-control" placeholder="{{__('label.label_here')}}">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>{{__('label.earning_coin')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="12_earning_coin" value="{{ $badge_data[11]['earning_coin'] }}" class="form-control" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group ml-4">
                                            <label>{{__('label.image')}}<span class="text-danger">*</span></label>
                                            <div class="avatar-upload">
                                                <div class="avatar-edit">
                                                    <input type='file' name="12_image" id="imageSelect_12" accept=".png, .jpg, .jpeg" />
                                                    <label for="imageSelect_12" title="{{__('label.upload_file')}}"></label>
                                                </div>
                                                <div class="avatar-preview">
                                                    <img src="{{$badge_data[11]['image']}}" id="imageView_12">
                                                </div>
                                            </div>
                                            <input type="hidden" name="12_old_image" value="{{$badge_data[11]['image']}}">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-12">
                                        <label>{{__('label.description')}}</label>
                                        <textarea name="12_description" rows="1" class="form-control" placeholder="{{__('label.description_here')}}">{{$badge_data[11]['description']}}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <!-- Refer Earn Badge -->
                    <div class="col-md-6">
                        <div class="card custom-border-card">
                            <div class="d-flex align-items-center justify-content-between border-bottom">
                                <h5 class="badge-header">{{ __('label.refer_earn_badge') }}</h5>
                                <button type="button" onclick="change_status(13)" id="13" class="{{ $badge_data[12]['status'] == 1 ? 'show-btn' : 'hide-btn' }} mb-2">
                                    {{ $badge_data[12]['status'] == 1 ? __('label.show') : __('label.hide') }}
                                </button>
                            </div>

                            <div class="card-body">
                                <div class="form-row">
                                    <div class="col-md-8">
                                        <div class="form-row">
                                            <div class="form-group col-md-12">
                                                <label>{{__('label.label')}}<span class="text-danger">*</span></label>
                                                <input type="text" name="13_label" value="{{ $badge_data[12]['label'] }}" class="form-control" placeholder="{{__('label.label_here')}}">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>{{__('label.min_referrals')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="13_min_referrals" value="{{ $badge_data[12]['min_referrals'] }}" class="form-control" placeholder="{{__('label.min_referrals_here')}}">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>{{__('label.earning_coin')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="13_earning_coin" value="{{ $badge_data[12]['earning_coin'] }}" class="form-control" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group ml-4">
                                            <label>{{__('label.image')}}<span class="text-danger">*</span></label>
                                            <div class="avatar-upload">
                                                <div class="avatar-edit">
                                                    <input type='file' name="13_image" id="imageSelect_13" accept=".png, .jpg, .jpeg" />
                                                    <label for="imageSelect_13" title="{{__('label.upload_file')}}"></label>
                                                </div>
                                                <div class="avatar-preview">
                                                    <img src="{{$badge_data[12]['image']}}" id="imageView_13">
                                                </div>
                                            </div>
                                            <input type="hidden" name="13_old_image" value="{{$badge_data[12]['image']}}">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-12">
                                        <label>{{__('label.description')}}</label>
                                        <textarea name="13_description" rows="1" class="form-control" placeholder="{{__('label.description_here')}}">{{$badge_data[12]['description']}}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Group Battles Badge -->
                    <div class="col-md-6">
                        <div class="card custom-border-card">
                            <div class="d-flex align-items-center justify-content-between border-bottom">
                                <h5 class="badge-header">{{ __('label.group_battles_badge') }}</h5>
                                <button type="button" onclick="change_status(14)" id="14" class="{{ $badge_data[13]['status'] == 1 ? 'show-btn' : 'hide-btn' }} mb-2">
                                    {{ $badge_data[13]['status'] == 1 ? __('label.show') : __('label.hide') }}
                                </button>
                            </div>

                            <div class="card-body">
                                <div class="form-row">
                                    <div class="col-md-8">
                                        <div class="form-row">
                                            <div class="form-group col-md-12">
                                                <label>{{__('label.label')}}<span class="text-danger">*</span></label>
                                                <input type="text" name="14_label" value="{{$badge_data[13]['label']}}" class="form-control" placeholder="{{__('label.label_here')}}">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>{{__('label.min_battles_win')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="14_min_pass_quiz" value="{{ $badge_data[13]['min_pass_quiz'] }}" class="form-control" placeholder="{{__('label.min_battles_here')}}">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>{{__('label.earning_coin')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="14_earning_coin" value="{{ $badge_data[13]['earning_coin'] }}" class="form-control" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group ml-4">
                                            <label>{{__('label.image')}}<span class="text-danger">*</span></label>
                                            <div class="avatar-upload">
                                                <div class="avatar-edit">
                                                    <input type='file' name="14_image" id="imageSelect_14" accept=".png, .jpg, .jpeg" />
                                                    <label for="imageSelect_14" title="{{__('label.upload_file')}}"></label>
                                                </div>
                                                <div class="avatar-preview">
                                                    <img src="{{ $badge_data[13]['image'] }}" id="imageView_14">
                                                </div>
                                            </div>
                                            <input type="hidden" name="14_old_image" value="{{ $badge_data[13]['image'] }}">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-12">
                                        <label>{{__('label.description')}}</label>
                                        <textarea name="14_description" rows="1" class="form-control" placeholder="{{__('label.description_here')}}">{{$badge_data[13]['description']}}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <!-- Exam Badge -->
                    <div class="col-md-6">
                        <div class="card custom-border-card">
                            <div class="d-flex align-items-center justify-content-between border-bottom">
                                <h5 class="badge-header">{{ __('label.exam_badge') }}</h5>
                                <button type="button" onclick="change_status(15)" id="15" class="{{ $badge_data[14]['status'] == 1 ? 'show-btn' : 'hide-btn' }} mb-2">
                                    {{ $badge_data[14]['status'] == 1 ? __('label.show') : __('label.hide') }}
                                </button>
                            </div>

                            <div class="card-body">
                                <div class="form-row">
                                    <div class="col-md-8">
                                        <div class="form-row">
                                            <div class="form-group col-md-12">
                                                <label>{{__('label.label')}}<span class="text-danger">*</span></label>
                                                <input type="text" name="15_label" value="{{ $badge_data[14]['label'] }}" class="form-control" placeholder="{{__('label.label_here')}}">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>{{__('label.min_exam_pass')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="15_min_pass_quiz" value="{{ $badge_data[14]['min_pass_quiz'] }}" class="form-control" placeholder="{{__('label.min_exam_here')}}">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>{{__('label.earning_coin')}}<span class="text-danger">*</span></label>
                                                <input type="number" name="15_earning_coin" value="{{ $badge_data[14]['earning_coin'] }}" class="form-control" placeholder="{{__('label.coin_here')}}">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group ml-4">
                                            <label>{{__('label.image')}}<span class="text-danger">*</span></label>
                                            <div class="avatar-upload">
                                                <div class="avatar-edit">
                                                    <input type='file' name="15_image" id="imageSelect_15" accept=".png, .jpg, .jpeg" />
                                                    <label for="imageSelect_15" title="{{__('label.upload_file')}}"></label>
                                                </div>
                                                <div class="avatar-preview">
                                                    <img src="{{$badge_data[14]['image']}}" id="imageView_15">
                                                </div>
                                            </div>
                                            <input type="hidden" name="15_old_image" value="{{$badge_data[14]['image']}}">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-12">
                                        <label>{{__('label.description')}}</label>
                                        <textarea name="15_description" rows="1" class="form-control" placeholder="{{__('label.description_here')}}">{{$badge_data[14]['description']}}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="border-top pt-3 text-right">
                    <button type="button" class="btn btn-default mw-120" onclick="badge_setting()">{{__('label.save')}}</button>
                    <input type="hidden" name="_token" value="{{ csrf_token() }}">
                </div>
            </form>
        </div>
    </div>
@endsection

@section('pagescript')
    <script>
        $(document).on('change', 'input[type="file"]', function () {
            const inputId = $(this).attr('id'); // Get the ID of the input
            const index = inputId.split('_')[1]; // Extract the index from the ID (e.g., 'imageSelect_1')
            const previewId = `#imageView_${index}`; // Target the corresponding preview image
            
            if (this.files && this.files[0]) {
                const reader = new FileReader();
                reader.onload = function (e) {
                    $(previewId).attr('src', e.target.result).hide().fadeIn(650);
                };
                reader.readAsDataURL(this.files[0]);
            }
        });

        function badge_setting() {

            var Demo_Mode = '<?php echo Demo_Mode(); ?>';
            if(Demo_Mode == 1){

                var formData = new FormData($("#badge_setting")[0]);
                $("#dvloader").show();
                $.ajax({
                    type: 'POST',
                    url: '{{ route("admin.badge.setting.save") }}',
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(resp) {
                        $("#dvloader").hide();
                        get_responce_message(resp, 'badge_setting', '{{ route("admin.badge.setting") }}');
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                showError();
            }
        }

        function change_status(id) {

            var Demo_Mode = '<?php echo Demo_Mode(); ?>';
            if(Demo_Mode == 1){

                $("#dvloader").show();
                var url = `{{ route('admin.badge.setting.status', '') }}/${id}`;

                $.ajax({
                    type: "POST",
                    url: url,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(resp) {
                        $("#dvloader").hide();

                        if (resp.status == 200) {
                            if (resp.status_code == 1) {
                                $('#' + id).text('{{__("label.show")}}').removeClass('hide-btn').addClass('show-btn');
                            } else {
                                $('#' + id).text('{{__("label.hide")}}').removeClass('show-btn').addClass('hide-btn');
                            }
                        } else {
                            toastr.error(resp.errors);
                        }
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                showError();
            }
        };
    </script>
@endsection